
CabViewZoom = {}
CabViewZoom.fovActive = true
CabViewZoom.fovMin = 20
CabViewZoom.fovMax = 80
CabViewZoom.fovHelper = false
CabViewZoom.actionEvents = {}

function CabViewZoom:prerequisitesPresent(specializations)
	return true
end
function CabViewZoom.registerEventListeners(vehicleType)
	for _, name in ipairs({"onLoad", "onRegisterActionEvents", "onUpdate", "onDraw"}) do
		SpecializationUtil.registerEventListener(vehicleType, name, CabViewZoom)
	end
end
function CabViewZoom.registerFunctions(vehicleType)
	for _, name in ipairs({"cvzgetActiveCamera", "updateFovLimits"}) do
		SpecializationUtil.registerFunction(vehicleType, name, CabViewZoom[name])
	end
end
function CabViewZoom:onLoad(savegame)
	local cvzSet = CabViewZoomMain.settings
	CabViewZoom.fovActive = cvzSet.fovActive or CabViewZoom.fovActive
	CabViewZoom.fovMin = cvzSet.fovMin or CabViewZoom.fovMin
	CabViewZoom.fovMax = cvzSet.fovMax or CabViewZoom.fovMax
	CabViewZoom.fovHelper = cvzSet.fovHelper or CabViewZoom.fovHelper
	if self.spec_CabViewZoom == nil then
		self.spec_CabViewZoom = {}
	end
	local spec = self.spec_CabViewZoom
	spec.actionEvents = {}
	spec.previousCamIndex = nil
	spec.cvzReset = true
end
function CabViewZoom:cvzgetActiveCamera()
    if not self.spec_enterable then
        return nil
    end
    local camIndex = self.spec_enterable.camIndex
    return camIndex and self.spec_enterable.cameras[camIndex] or nil
end
function CabViewZoom:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	if self.isClient then
		local camera = self:cvzgetActiveCamera()
		if self.getIsEntered ~= nil and self:getIsEntered() and camera ~= nil and camera.cameraNode ~= nil then
			local spec = self.spec_CabViewZoom
			if spec ~= nil and spec.actionEvents ~= nil then
				self:clearActionEventsTable(spec.actionEvents)
				if isActiveForInputIgnoreSelection then
					local _, resetEventId = self:addActionEvent(spec.actionEvents, InputAction.CABVIEWZOOM_RESET, self, CabViewZoom.resetCameraZoom, true, true, false, true, nil)
					g_inputBinding:setActionEventTextPriority(resetEventId, GS_PRIO_NORMAL)
					CabViewZoom.updateActionEvents(self)
				end
			end
		end
	end
end
function CabViewZoom.updateActionEvents(self)
	local spec = self.spec_CabViewZoom
	if spec == nil then return end
	local actionEvent = spec.actionEvents[InputAction.CABVIEWZOOM_RESET]
	if actionEvent ~= nil then
		local camera = self:cvzgetActiveCamera()
		local inside = CabViewZoom.fovActive and camera ~= nil and camera.isInside
		g_inputBinding:setActionEventTextVisibility(actionEvent.actionEventId, inside)
		g_inputBinding:setActionEventActive(actionEvent.actionEventId, inside)
	end
end
function CabViewZoom:onUpdate(dt)
	local spec = self.spec_CabViewZoom
	local camera = self:cvzgetActiveCamera()
	local camIndex = self.spec_enterable and self.spec_enterable.camIndex
	if camera ~= nil then
		if spec.previousCamIndex ~= camIndex then
			spec.previousCamIndex = camIndex
			CabViewZoom.updateActionEvents(self)
		end
		if not CabViewZoom.fovActive and spec.cvzReset then
			spec.cvzReset = false
			camera.fovY = camera.origFovY
			camera.fovTarget = camera.origFovY
			setFovY(camera.cameraNode, camera.fovY)
			CabViewZoom.updateActionEvents(self) 
		end
		if CabViewZoom.fovActive then
			spec.cvzReset = true
			local target = camera.fovTarget or camera.fovY
			camera.fovY = target + math.pow(0.99579, dt) * (camera.fovY - target)
			setFovY(camera.cameraNode, camera.fovY)
		end
	end
end
function CabViewZoom:onDraw(isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	local spec = self.spec_CabViewZoom
	local camera = self:cvzgetActiveCamera()
	if CabViewZoom.fovActive and CabViewZoom.fovHelper and not g_gui:getIsGuiVisible() and camera.isInside and camera.isActivated then
		setTextColor(unpack(HUD.COLOR.ACTIVE))
		setTextAlignment(RenderText.ALIGN_CENTER)
		renderText(0.5, 0.14, 0.02, "CabViewZoom")
		renderText(0.5, 0.12, 0.02, string.format("MinZoom: %d", CabViewZoom.fovMin))
		renderText(0.5, 0.10, 0.02, string.format("MaxZoom: %d", CabViewZoom.fovMax))
		renderText(0.5, 0.08, 0.02, string.format("CurrentZoom: %d", MathUtil.round(math.deg(camera.fovY), 2)))
		setTextAlignment(RenderText.ALIGN_LEFT)
	end
end
function CabViewZoom:resetCameraZoom(actionName, inputValue, direction, isAnalog, isMouse)
	if g_gui:getIsGuiVisible() then	return end
	local camera = self:cvzgetActiveCamera()
	if camera == nil or not camera.isInside or not camera.isActivated then
		return
	end
	camera.fovTarget = camera.origFovY
end
function CabViewZoom.updateFovLimits(fovActive, fovMin, fovMax, fovHelper)
	if fovActive ~= nil then CabViewZoom.fovActive = fovActive end
	if fovMin ~= nil then CabViewZoom.fovMin = fovMin end
	if fovMax ~= nil then CabViewZoom.fovMax = fovMax end
	if fovHelper ~= nil then CabViewZoom.fovHelper = fovHelper end
end

VehicleCamera.loadFromXML = Utils.overwrittenFunction(VehicleCamera.loadFromXML, function(self, superFunc, xmlFile, key, savegame, cameraIndex)
	if not superFunc(self, xmlFile, key, savegame, cameraIndex) then
		return false
	end
	self.origFovY = self.origFovY or self.fovY
	self.fovTarget = self.fovTarget or self.fovY
	return true
end)
VehicleCamera.zoomSmoothly = Utils.appendedFunction(VehicleCamera.zoomSmoothly, function(self, offset)
	if self.isInside then
		local newFov = (self.fovTarget or self.fovY) + (offset / InputBinding.MOUSE_WHEEL_INPUT_FACTOR)
		newFov = math.max(math.min(newFov, math.rad(CabViewZoom.fovMax)), math.rad(CabViewZoom.fovMin))
		self.fovTarget = newFov
	end
end)
