
CabViewZoomSettingsUI = {}
local CabViewZoomSettingsUI_mt = Class(CabViewZoomSettingsUI)

function CabViewZoomSettingsUI.new(settings)
	local self = setmetatable({}, CabViewZoomSettingsUI_mt)
	self.controls = {}
	self.settings = settings
	return self
end
function CabViewZoomSettingsUI:injectUiSettings()
	local settingsPage = g_gui.screenControllers[InGameMenu].pageSettings
	local controlProperties = {
		{name = "fovActive", autoBind = true},
		{name = "fovMin", min = 5, max = 40, step = 1, unit = "", autoBind = true},
		{name = "fovMax", min = 61, max = 120, step = 1, unit = "", autoBind = true},
		{name = "fovHelper", autoBind = true}
	}
	UIHelper.createControlsDynamically(settingsPage, "cabviewzoom_section_title", self, controlProperties, "cabviewzoom_")
	UIHelper.setupAutoBindControls(self, self.settings, CabViewZoomSettingsUI.onSettingsChange)
	self:updateUiElements()
	InGameMenuSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuSettingsFrame.onFrameOpen, function()
		self:updateUiElements(true)
	end)
end
function CabViewZoomSettingsUI:onSettingsChange()
	CabViewZoom.updateFovLimits(self.settings.fovActive, self.settings.fovMin, self.settings.fovMax, self.settings.fovHelper)
	self:updateUiElements()
	CabViewZoomSettingsRepository.storeSettings(self.settings)
end
function CabViewZoomSettingsUI:updateUiElements(skipAutoBindControls)
	if not skipAutoBindControls then
		self.populateAutoBindControls()
	end
end