
CabViewZoomSettingsRepository = {}
ModSettingsDirectory = g_currentModSettingsDirectory

function getSettingsPath()
	local dir = ModSettingsDirectory or (getUserProfileAppPath() .. "modSettings/")
	createFolder(dir)
	return Utils.getFilename("CabViewZoomSettings.xml", dir)
end
function CabViewZoomSettingsRepository.storeSettings(settings)
	local xmlPath = getSettingsPath()
	local xmlFile = createXMLFile("CabViewZoomSettings", xmlPath, "CabViewZoomSettings")
	setXMLBool(xmlFile, "CabViewZoomSettings.fovActive#state", settings.fovActive)
	setXMLInt(xmlFile, "CabViewZoomSettings.fovMin#state", settings.fovMin)
	setXMLInt(xmlFile, "CabViewZoomSettings.fovMax#state", settings.fovMax)
	setXMLBool(xmlFile, "CabViewZoomSettings.fovHelper#state", settings.fovHelper)
	saveXMLFile(xmlFile)
	delete(xmlFile)
	--Logging.info("%s: Saved settings to %s", MOD_NAME, xmlPath)
end
function CabViewZoomSettingsRepository.restoreSettings(settings)
	local xmlPath = getSettingsPath()
	if not fileExists(xmlPath) then
		Logging.info("%s: No settings file found, using defaults.", MOD_NAME)
		return
	end
	local xmlFile = loadXMLFile("CabViewZoomSettings", xmlPath)
	settings.fovActive = getXMLBool(xmlFile, "CabViewZoomSettings.fovActive#state") or settings.fovActive
	settings.fovMin = getXMLInt(xmlFile, "CabViewZoomSettings.fovMin#state") or settings.fovMin
	settings.fovMax = getXMLInt(xmlFile, "CabViewZoomSettings.fovMax#state") or settings.fovMax
	settings.fovHelper = getXMLBool(xmlFile, "CabViewZoomSettings.fovHelper#state") or settings.fovHelper
	delete(xmlFile)
end