
MOD_NAME = g_currentModName
MOD_DIR = g_currentModDirectory

CabViewZoomMain = {}
CabViewZoomMain.settings = CabViewZoomSettings.new()
CabViewZoomSettingsRepository.restoreSettings(CabViewZoomMain.settings)
TypeManager.finalizeTypes = Utils.prependedFunction(TypeManager.finalizeTypes, function(typeManager)
	if typeManager.typeName == "vehicle" then
		CabViewZoomMain.installSpecializations(g_vehicleTypeManager, g_specializationManager, MOD_DIR, MOD_NAME)
	end
end)
function CabViewZoomMain.installSpecializations(vehicleTypeManager, specializationManager, modDirectory, modName)
	if specializationManager:getSpecializationByName("CabViewZoom") == nil then
		specializationManager:addSpecialization("CabViewZoom", "CabViewZoom", Utils.getFilename("scripts/vehicles/specializations/CabViewZoom.lua", modDirectory), nil)
	end
	for typeName, typeEntry in pairs(vehicleTypeManager:getTypes()) do
		local excludedTypes = {
			locomotive = true, trainTrailer = true, trainTimberTrailer = true, conveyorBelt = true,
			pickupConveyorBelt = true, woodCrusherTrailerDrivable = true, baleWrapper = true,
			["FS25_gameplay_Real_Vehicle_Breakdowns.palletbattery"] = true,
			["FS25_JCB_Powerpack.palletbattery"] = true,
			highPressureWasher = true, inlineWrapper = true
		}
		if typeEntry ~= nil and not excludedTypes[typeName] then
			if SpecializationUtil.hasSpecialization(Drivable, typeEntry.specializations) and
				SpecializationUtil.hasSpecialization(Enterable, typeEntry.specializations) and
				SpecializationUtil.hasSpecialization(Motorized, typeEntry.specializations) and
				not SpecializationUtil.hasSpecialization(CabViewZoom, typeEntry.specializations) then
				vehicleTypeManager:addSpecialization(typeName, modName .. ".CabViewZoom")
				-- Logging.info("  Register CabViewZoom '" .. typeName .. "'")
			end
		else
			-- Logging.info("  No register CabViewZoom '" .. typeName .. "'")
		end
	end
end
Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, function()
	if CabViewZoomSettingsUI ~= nil then
		local ui = CabViewZoomSettingsUI.new(CabViewZoomMain.settings)
		ui:injectUiSettings()
	end
end)